/*
 * Decompiled with CFR 0.152.
 */
package com.github.toxuin;

import com.github.toxuin.PVPGear;
import com.github.toxuin.PVPItem;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PVPGearReferee {
    public static Set<PVPItem> pvpWeapons = new HashSet<PVPItem>();
    public static Set<PVPItem> pvpArmor = new HashSet<PVPItem>();
    public static Set<PVPItem> pvpEnchants = new HashSet<PVPItem>();
    private static Logger log = Logger.getLogger("Minecraft");

    public static int getPvpDamage(Player bully, Player victim, int newDamage) {
        int magicDefense;
        newDamage *= (int)Math.round(PVPGearReferee.checkWeapon(bully, true));
        newDamage *= (int)Math.round(PVPGearReferee.checkEnchantments(bully, true));
        int defense = (int)Math.round(PVPGearReferee.checkArmor(victim, true));
        if (defense != 0) {
            newDamage /= defense;
        }
        if ((magicDefense = (int)Math.round(PVPGearReferee.checkEnchantments(victim, true))) != 0) {
            newDamage /= magicDefense;
        }
        int victimFireTicks = PVPGearReferee.checkFireTicks(victim, true);
        int bullyFireTicks = PVPGearReferee.checkFireTicks(bully, true);
        if (victimFireTicks != 0) {
            bully.setFireTicks(victimFireTicks);
        }
        if (victimFireTicks != 0) {
            victim.setFireTicks(bullyFireTicks);
        }
        return newDamage;
    }

    public static int getPveDamage(Player bully, Entity victim, int newDamage) {
        double chkWep = PVPGearReferee.checkWeapon(bully, false);
        double chkEnch = PVPGearReferee.checkEnchantments(bully, false);
        double chkArm = PVPGearReferee.checkArmor(bully, false);
        newDamage *= (int)Math.round(chkWep);
        newDamage *= (int)Math.round(chkEnch);
        newDamage *= (int)Math.round(chkArm);
        int fireTicks = PVPGearReferee.checkFireTicks(bully, false);
        if (fireTicks != 0) {
            victim.setFireTicks(fireTicks);
        }
        return newDamage;
    }

    public static int checkFireTicks(Player player, boolean pvp) {
        int n;
        int n2;
        ItemStack[] itemStackArray;
        PVPItem.Effects effectSet;
        int result = 0;
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (PVPItem aura : pvpEnchants) {
            PVPItem.Effects effects = effectSet = pvp ? aura.pvpEffects : aura.pveEffects;
            if (effectSet.ignite != 0) {
                Map enchantments = player.getItemInHand().getEnchantments();
                int i = 0;
                while (i < enchantments.size()) {
                    Object[] enchantsAll = enchantments.keySet().toArray();
                    Object[] enchantsLevels = enchantments.values().toArray();
                    Enchantment ench = (Enchantment)enchantsAll[i];
                    if (aura.id.intValue() == ench.getId()) {
                        log.info(String.valueOf(PVPGear.prefix) + "DEBUG: " + player.getDisplayName() + " GOT AN IGNITING ENCHANT ON HIS WEAPON " + ench.getId() + " (" + ench.getName() + ") Level : " + enchantsLevels[i].toString());
                        result += effectSet.ignite * Integer.parseInt(enchantsLevels[i].toString());
                    }
                    ++i;
                }
            }
            itemStackArray = armor;
            n2 = armor.length;
            n = 0;
            while (n < n2) {
                ItemStack gear = itemStackArray[n];
                Map enchantments = gear.getEnchantments();
                int i = 0;
                while (i < enchantments.size()) {
                    Object[] enchantsAll = enchantments.keySet().toArray();
                    Object[] enchantsLevels = enchantments.values().toArray();
                    Enchantment ench = (Enchantment)enchantsAll[i];
                    if (effectSet.ignite != 0 && aura.id.intValue() == ench.getId()) {
                        if (PVPGear.debug) {
                            log.info(String.valueOf(PVPGear.prefix) + "DEBUG: ENCHANTMENTS ON PLAYER " + player.getDisplayName() + ": " + ench.getId() + " (" + ench.getName() + ") Level : " + enchantsLevels[i].toString());
                        }
                        result += effectSet.ignite * Integer.parseInt(enchantsLevels[i].toString());
                    }
                    ++i;
                }
                ++n;
            }
        }
        for (PVPItem weapon : pvpWeapons) {
            PVPItem.Effects effects = effectSet = pvp ? weapon.pvpEffects : weapon.pveEffects;
            if (Material.getMaterial((int)weapon.id) != player.getItemInHand().getType() || effectSet.ignite == 0) continue;
            result += effectSet.ignite.intValue();
            if (!PVPGear.debug) continue;
            log.info(String.valueOf(PVPGear.prefix) + "DEBUG: CHECK " + player.getDisplayName() + " FOR IGNITING WEAPON: " + effectSet.ignite);
        }
        for (PVPItem gear : pvpArmor) {
            effectSet = pvp ? gear.pvpEffects : gear.pveEffects;
            itemStackArray = armor;
            n2 = armor.length;
            n = 0;
            while (n < n2) {
                ItemStack piece = itemStackArray[n];
                if (Material.getMaterial((int)gear.id) == piece.getType() && effectSet.ignite != 0) {
                    result += effectSet.ignite.intValue();
                    if (PVPGear.debug) {
                        log.info(String.valueOf(PVPGear.prefix) + "DEBUG: CHECK " + player.getDisplayName() + " FOR IGNITING ARMOR: " + effectSet.ignite);
                    }
                }
                ++n;
            }
        }
        return result;
    }

    private static double checkWeapon(Player player, boolean pvp) {
        double result = 1.0;
        for (PVPItem item : pvpWeapons) {
            PVPItem.Effects effectSet;
            PVPItem.Effects effects = effectSet = pvp ? item.pvpEffects : item.pveEffects;
            if (effectSet.damage == 1.0 && effectSet.damage == 0.0 || Material.getMaterial((int)item.id) != player.getItemInHand().getType()) continue;
            result = effectSet.damage;
            if (!PVPGear.debug) continue;
            log.info(String.valueOf(PVPGear.prefix) + "DEBUG: CHECK " + player.getDisplayName() + "'S WEAPON: x" + effectSet.damage);
        }
        return result;
    }

    private static double checkArmor(Player player, boolean pvp) {
        double armorPoints = 0.0;
        double helm = 15.0;
        double chest = 40.0;
        double pants = 30.0;
        double boots = 15.0;
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (PVPItem item : pvpArmor) {
            PVPItem.Effects effectSet;
            PVPItem.Effects effects = effectSet = pvp ? item.pvpEffects : item.pveEffects;
            if (effectSet.damage == 1.0 && effectSet.damage == 0.0) continue;
            if (armor[0].getType() == Material.getMaterial((int)item.id) && effectSet.damage != 0.0) {
                helm *= effectSet.damage;
            }
            if (armor[1].getType() == Material.getMaterial((int)item.id) && effectSet.damage != 0.0) {
                pants *= effectSet.damage;
            }
            if (armor[2].getType() == Material.getMaterial((int)item.id) && effectSet.damage != 0.0) {
                chest *= effectSet.damage;
            }
            if (armor[3].getType() != Material.getMaterial((int)item.id) || effectSet.damage == 0.0) continue;
            boots *= effectSet.damage;
        }
        armorPoints = (helm + chest + pants + boots) / 100.0;
        if (PVPGear.debug) {
            log.info(String.valueOf(PVPGear.prefix) + "DEBUG: CHECK " + player.getDisplayName() + "'S ARMOR: " + armorPoints);
            log.info(String.valueOf(PVPGear.prefix) + "DEBUG: BOOTS: " + boots + ", PANTS: " + pants + ", CHEST: " + chest + ", HELM: " + helm);
        }
        return armorPoints;
    }

    private static double checkEnchantments(Player player, boolean pvp) {
        double result = 1.0;
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (PVPItem aura : pvpEnchants) {
            PVPItem.Effects effectSet;
            PVPItem.Effects effects = effectSet = pvp ? aura.pvpEffects : aura.pveEffects;
            if (effectSet.damage != 1.0 && effectSet.damage != 0.0) {
                Map enchantments = player.getItemInHand().getEnchantments();
                int i = 0;
                while (i < enchantments.size()) {
                    Object[] enchantsAll = enchantments.keySet().toArray();
                    Object[] enchantsLevels = enchantments.values().toArray();
                    Enchantment ench = (Enchantment)enchantsAll[i];
                    if (aura.id.intValue() == ench.getId()) {
                        log.info(String.valueOf(PVPGear.prefix) + "DEBUG: " + player.getDisplayName() + " GOT AN ENCHANT ON HIS WEAPON " + ench.getId() + " (" + ench.getName() + ") Level : " + enchantsLevels[i].toString());
                        result = result * effectSet.damage * (double)Integer.parseInt(enchantsLevels[i].toString());
                    }
                    ++i;
                }
            }
            ItemStack[] itemStackArray = armor;
            int n = armor.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack gear = itemStackArray[n2];
                Map enchantments = gear.getEnchantments();
                int i = 0;
                while (i < enchantments.size()) {
                    Object[] enchantsAll = enchantments.keySet().toArray();
                    Object[] enchantsLevels = enchantments.values().toArray();
                    Enchantment ench = (Enchantment)enchantsAll[i];
                    if (effectSet.damage != 1.0 && effectSet.damage != 0.0 && aura.id.intValue() == ench.getId()) {
                        log.info(String.valueOf(PVPGear.prefix) + "DEBUG: ENCHANTMENTS ON PLAYER " + player.getDisplayName() + ": " + ench.getId() + " (" + ench.getName() + ") Level : " + enchantsLevels[i].toString());
                        result = result * effectSet.damage * (double)Integer.parseInt(enchantsLevels[i].toString());
                    }
                    ++i;
                }
                ++n2;
            }
        }
        return result;
    }
}

