/*
 * Decompiled with CFR 0.152.
 */
package com.github.toxuin;

import com.github.toxuin.PVPGearReferee;
import com.github.toxuin.PVPItem;
import java.io.File;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PVPGear
extends JavaPlugin
implements Listener {
    public static String prefix = null;
    public static File directory;
    public static boolean debug;
    private static FileConfiguration config;
    private static File configFile;
    private Logger log = Logger.getLogger("Minecraft");

    static {
        debug = false;
        config = null;
        configFile = null;
    }

    public void onEnable() {
        directory = this.getDataFolder();
        PluginDescriptionFile pdfFile = this.getDescription();
        prefix = "[" + pdfFile.getName() + "]: ";
        this.readConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.log.info(String.valueOf(prefix) + "Enabled! Version: " + pdfFile.getVersion());
    }

    public void onDisable() {
        this.log.info(String.valueOf(prefix) + "Disabled.");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Projectile bullet;
        LivingEntity shooter;
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent attackEvent = (EntityDamageByEntityEvent)event;
        Entity attacked = event.getEntity();
        Entity attacker = attackEvent.getDamager();
        if (attacker instanceof Player && attacked instanceof Player) {
            Player bully = (Player)attacker;
            Player victim = (Player)attacked;
            if (!bully.hasPermission("pvpgear.pvp")) {
                return;
            }
            int oldDamage = attackEvent.getDamage();
            int newDamage = PVPGearReferee.getPvpDamage(bully, victim, attackEvent.getDamage());
            if (newDamage < 0) {
                newDamage = 0;
            }
            if (debug) {
                this.log.info(String.valueOf(prefix) + "DEBUG: " + bully.getDisplayName() + " is hitting " + victim.getDisplayName() + " with " + bully.getItemInHand().getType().name());
                this.log.info(String.valueOf(prefix) + "DEBUG: was damage: " + oldDamage + " new damage: " + newDamage);
            }
            attackEvent.setDamage(newDamage);
        } else if (attacker instanceof Projectile && attacked instanceof Player) {
            Projectile bullet2 = (Projectile)attacker;
            LivingEntity shooter2 = bullet2.getShooter();
            if (shooter2 instanceof Player) {
                if (bullet2 instanceof Snowball) {
                    return;
                }
                if (bullet2 instanceof EnderPearl) {
                    return;
                }
                Player bully = (Player)shooter2;
                Player victim = (Player)attacked;
                if (!bully.hasPermission("pvpgear.pvp")) {
                    return;
                }
                int oldDamage = attackEvent.getDamage();
                int newDamage = PVPGearReferee.getPvpDamage(bully, victim, attackEvent.getDamage());
                if (newDamage < 0) {
                    newDamage = 0;
                }
                if (debug) {
                    this.log.info(String.valueOf(prefix) + "DEBUG: " + bully.getDisplayName() + " is shooting at " + victim.getDisplayName() + " with " + bullet2.toString());
                    this.log.info(String.valueOf(prefix) + "DEBUG: was damage: " + oldDamage + " new damage: " + newDamage);
                }
                attackEvent.setDamage(newDamage);
            }
        } else if (attacker instanceof Player && attacked instanceof CraftMonster) {
            Player bully = (Player)attacker;
            if (!bully.hasPermission("pvpgear.pve")) {
                return;
            }
            int oldDamage = attackEvent.getDamage();
            int newDamage = PVPGearReferee.getPveDamage(bully, attacked, attackEvent.getDamage());
            if (newDamage < 0) {
                newDamage = 0;
            }
            if (debug) {
                this.log.info(String.valueOf(prefix) + "DEBUG: " + bully.getDisplayName() + " is hitting " + attacked.toString() + " with " + bully.getItemInHand().getType().name());
                this.log.info(String.valueOf(prefix) + "DEBUG: was damage: " + oldDamage + " new damage: " + newDamage);
            }
            if (debug) {
                this.log.info(String.valueOf(prefix) + "DEBUG: " + bully.getDisplayName() + " is attacking " + attacked.toString());
            }
            attackEvent.setDamage(newDamage);
        } else if (attacker instanceof Projectile && attacked instanceof CraftMonster && (shooter = (bullet = (Projectile)attacker).getShooter()) instanceof Player) {
            Player bully = (Player)shooter;
            if (!bully.hasPermission("pvpgear.pve")) {
                return;
            }
            int oldDamage = attackEvent.getDamage();
            int newDamage = PVPGearReferee.getPveDamage(bully, attacked, attackEvent.getDamage());
            if (newDamage < 0) {
                newDamage = 0;
            }
            if (debug) {
                this.log.info(String.valueOf(prefix) + "DEBUG: " + bully.getDisplayName() + " is shooting at " + attacked.getType().getName() + " with " + bullet.toString());
                this.log.info(String.valueOf(prefix) + "DEBUG: was damage: " + oldDamage + " new damage: " + newDamage);
            }
            attackEvent.setDamage(newDamage);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (cmd.getName().equalsIgnoreCase("pvpgear")) {
            if (args[0].equalsIgnoreCase("reload") && sender instanceof ConsoleCommandSender) {
                PVPGearReferee.pvpWeapons.clear();
                PVPGearReferee.pvpArmor.clear();
                PVPGearReferee.pvpEnchants.clear();
                this.readConfig();
            }
            return true;
        }
        return false;
    }

    private void readConfig() {
        configFile = new File(directory, "config.yml");
        config = YamlConfiguration.loadConfiguration((File)configFile);
        if (configFile.exists()) {
            PVPItem item;
            Set weapons = config.getConfigurationSection("weapons").getKeys(false);
            Set armor = config.getConfigurationSection("armor").getKeys(false);
            Set auras = config.getConfigurationSection("enchantments").getKeys(false);
            debug = config.getBoolean("Debug");
            for (String weapon : weapons) {
                item = new PVPItem();
                item.id = Integer.parseInt(weapon);
                item.pvpEffects.damage = config.getDouble("weapons." + weapon + ".pvp-effects.damage");
                item.pvpEffects.ignite = config.getInt("weapons." + weapon + ".pvp-effects.ignite");
                item.pveEffects.damage = config.getDouble("weapons." + weapon + ".pve-effects.damage");
                item.pveEffects.ignite = config.getInt("weapons." + weapon + ".pve-effects.ignite");
                item.name = config.getString("weapons." + weapon + ".name");
                PVPGearReferee.pvpWeapons.add(item);
            }
            for (String gear : armor) {
                item = new PVPItem();
                item.id = Integer.parseInt(gear);
                item.pvpEffects.damage = config.getDouble("armor." + gear + ".pvp-effects.damage");
                item.pvpEffects.ignite = config.getInt("armor." + gear + ".pvp-effects.ignite");
                item.pveEffects.damage = config.getDouble("armor." + gear + ".pvp-effects.damage");
                item.pveEffects.ignite = config.getInt("armor." + gear + ".pvp-effects.ignite");
                item.name = config.getString("armor." + gear + ".name");
                PVPGearReferee.pvpArmor.add(item);
            }
            for (String ench : auras) {
                PVPItem enchant = new PVPItem();
                enchant.id = Integer.parseInt(ench);
                enchant.pvpEffects.damage = config.getDouble("enchantments." + ench + ".pvp-effects.damage");
                enchant.pvpEffects.ignite = config.getInt("enchantments." + ench + ".pvp-effects.ignite");
                enchant.name = config.getString("armor." + ench + ".name");
                PVPGearReferee.pvpEnchants.add(enchant);
            }
            if (debug) {
                this.log.info(String.valueOf(prefix) + "DEBUG: loaded weapons: " + PVPGearReferee.pvpWeapons.size());
                this.log.info(String.valueOf(prefix) + "DEBUG: loaded armor: " + PVPGearReferee.pvpArmor.size());
            }
            this.log.info(String.valueOf(prefix) + "Config loaded!");
        } else {
            config.set("weapons.283.name", (Object)"golden sword");
            config.set("weapons.283.pvp-effects.damage", (Object)1.0);
            config.set("weapons.283.pvp-effects.ignite", (Object)0);
            config.set("weapons.283.pve-effects.damage", (Object)1.0);
            config.set("weapons.283.pve-effects.ignite", (Object)0);
            config.set("weapons.267.name", (Object)"iron sword");
            config.set("weapons.267.pvp-effects.damage", (Object)1.0);
            config.set("weapons.267.pvp-effects.ignite", (Object)0);
            config.set("weapons.267.pve-effects.damage", (Object)1.0);
            config.set("weapons.267.pve-effects.ignite", (Object)0);
            config.set("armor.314.name", (Object)"golden helmet");
            config.set("armor.314.pvp-effects.damage", (Object)1.0);
            config.set("armor.314.pvp-effects.ignite", (Object)0);
            config.set("armor.314.pve-effects.damage", (Object)1.0);
            config.set("armor.314.pve-effects.ignite", (Object)0);
            config.set("armor.315.name", (Object)"golden chestplate");
            config.set("armor.315.pvp-effects.damage", (Object)1.0);
            config.set("armor.315.pvp-effects.ignite", (Object)0);
            config.set("armor.315.pve-effects.damage", (Object)1.0);
            config.set("armor.315.pve-effects.ignite", (Object)0);
            config.set("armor.316.name", (Object)"golden pants");
            config.set("armor.316.pvp-effects.damage", (Object)1.0);
            config.set("armor.316.pvp-effects.ignite", (Object)0);
            config.set("armor.316.pve-effects.damage", (Object)1.0);
            config.set("armor.316.pve-effects.ignite", (Object)0);
            config.set("armor.317.name", (Object)"golden boots");
            config.set("armor.317.pvp-effects.damage", (Object)1.0);
            config.set("armor.317.pvp-effects.ignite", (Object)0);
            config.set("armor.317.pve-effects.damage", (Object)1.0);
            config.set("armor.317.pve-effects.ignite", (Object)0);
            config.set("enchantments.3.name", (Object)"protection from explosions");
            config.set("enchantments.3.pvp-effects.damage", (Object)1.0);
            config.set("enchantments.3.pvp-effects.ignite", (Object)0);
            config.set("enchantments.3.pve-effects.damage", (Object)1.0);
            config.set("enchantments.3.pve-effects.ignite", (Object)0);
            config.set("enchantments.17.name", (Object)"damage to undead");
            config.set("enchantments.17.pvp-effects.damage", (Object)1);
            config.set("enchantments.17.pvp-effects.ignite", (Object)0);
            config.set("enchantments.17.pve-effects.damage", (Object)1.0);
            config.set("enchantments.17.pve-effects.ignite", (Object)0);
            config.set("Version", (Object)this.getDescription().getVersion());
            config.set("Debug", (Object)false);
            try {
                config.save(configFile);
                this.log.info(String.valueOf(prefix) + "CREATED DEFAULT CONFIG");
            }
            catch (Exception e) {
                this.log.info(String.valueOf(prefix) + "ERROR when creating config.yml");
                e.printStackTrace();
            }
        }
    }
}

